<?php
    defined('PF_VERSION') OR exit('Access denied');
$theme_info = array (
        'name' => 'Aphrodite',
        'version' => '1.0',
        'description' => 'This is an Aphrodite theme description' 
);

require dirname(__FILE__).'/aphrodite-shortcode-class.php';

$pf_aphrodite_shortcode = new Pf_Aphrodite_Shortcode ();
$shortcode_maps = get_class_methods($pf_aphrodite_shortcode);

$exclude_tags = array('google_map','general','youtube_video','vimeo_video','alert');

foreach ( $shortcode_maps as $v ) {
    if (in_array($v, $exclude_tags)) continue;
    Pf::shortcode ()->add ( $v, array (
        $pf_aphrodite_shortcode,
        $v
    ),'bt');
}foreach ( $shortcode_maps as $v ) {
    if (in_array($v, $exclude_tags)) continue;
    Pf::shortcode ()->add ( $v, array (
        $pf_aphrodite_shortcode,
        $v
    ),'html');
}
$general_tags = array(
        'h1','h2','h3','h4','h5','h6','div','span','p','strong','em','abbr','a','address',
        'blockquote','footer','cite','ul','li','ol','dl','dt', 'img','iframe','small'
);

foreach ( $general_tags as $v ) {
        Pf::shortcode ()->add ( $v, array (
            $pf_aphrodite_shortcode,
            'general'
        ),'bt');
}
foreach ( $general_tags as $v ) {
        Pf::shortcode ()->add ( $v, array (
            $pf_aphrodite_shortcode,
            'general'
        ),'html');
}

Pf::shortcode ()->add ( 'slide', array (
    $pf_aphrodite_shortcode,
    'moza_slide'
),'moza');

Pf::shortcode ()->add ( 'slider', array (
$pf_aphrodite_shortcode,
'moza_slider'
),'moza');

Pf::shortcode ()->add ( 'map', array (
    $pf_aphrodite_shortcode,
    'google_map'
),'google');

Pf::shortcode ()->add ( 'video', array (
    $pf_aphrodite_shortcode,
    'youtube_video'
),'youtube');

Pf::shortcode ()->add ( 'video', array (
    $pf_aphrodite_shortcode,
    'vimeo_video'
),'vimeo');

Pf::shortcode ()->add ( 'audio', array (
    $pf_aphrodite_shortcode,
    'soundcloud_audio'
),'soundcloud');


Pf::shortcode ()->add ( 'script', array (
    $pf_aphrodite_shortcode,
    'general'
),'html');

Pf::shortcode()->add('i', array(
    $pf_aphrodite_shortcode,
    'i_element'
        ), 'html');

Pf::shortcode()->add('i', array(
    $pf_aphrodite_shortcode,
    'i_element'
        ), 'bt');

Pf::shortcode()->add('colorbox', array(
    $pf_aphrodite_shortcode,
    'colorbox'
        ), 'style');

Pf::shortcode()->add('img', array(
    $pf_aphrodite_shortcode,
    'imgslide'
        ), 'slider');

Pf::shortcode()->add('carousel', array(
    $pf_aphrodite_shortcode,
    'carousel'
        ), 'slider');
Pf::shortcode()->add('jcarousel', array(
        $pf_aphrodite_shortcode,
        'jcarouselslider'
            ), 'slider');
$table_class    =   array('normal','table-striped','table-bordered','table-hover','table-condensed','table-responsive');
foreach ($table_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'table_old'
            ), 'table');
}
$row_class      =   array('normal','active','success','warning','danger','info');
foreach ($row_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'row_table'
            ), 'tr');
}
foreach ($row_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'col_table'
            ), 'td');
}
foreach ($row_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'head_table'
            ), 'th');
}
Pf::shortcode()->add('table', array(
        $pf_aphrodite_shortcode,
        'table'
            ), 'html');
Pf::shortcode()->add('tr', array(
        $pf_aphrodite_shortcode,
        'table_row'
            ), 'html');
Pf::shortcode()->add('td', array(
        $pf_aphrodite_shortcode,
        'table_col'
            ), 'html');
Pf::shortcode()->add('th', array(
        $pf_aphrodite_shortcode,
        'table_head'
            ), 'html');
$boxline_class  =   array('top','left','right','bottom');
foreach ($boxline_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'borderbox'
            ), 'borderbox');
}
Pf::shortcode()->add('ul', array(
        $pf_aphrodite_shortcode,
        'list_ul'
            ), 'list');
Pf::shortcode()->add('_ul', array(
        $pf_aphrodite_shortcode,
        'list_ul'
            ), 'list');
Pf::shortcode()->add('__ul', array(
        $pf_aphrodite_shortcode,
        'list_ul'
            ), 'list');
Pf::shortcode()->add('ol', array(
        $pf_aphrodite_shortcode,
        'list_ol'
            ), 'list');
Pf::shortcode()->add('_ol', array(
        $pf_aphrodite_shortcode,
        'list_ol'
            ), 'list');
Pf::shortcode()->add('__ol', array(
        $pf_aphrodite_shortcode,
        'list_ol'
            ), 'list');
Pf::shortcode()->add('li', array(
        $pf_aphrodite_shortcode,
        'list_li'
            ), 'list');
Pf::shortcode()->add('_li', array(
        $pf_aphrodite_shortcode,
        'list_li'
            ), 'list');
Pf::shortcode()->add('__li', array(
        $pf_aphrodite_shortcode,
        'list_li'
            ), 'list');
$social_icon    =   array('rss','facebook','twitter','vimeo','googleplus','pintrest','linkedin','dropbox','picasa','spotify','jolicloud','wordpress','github','xing');
foreach($social_icon as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'social_icon'
            ), 'social');
}
Pf::shortcode()->add('list', array(
    $pf_aphrodite_shortcode,
    'social_list'
        ), 'social');

$pricing_class=array('normal','hover');
foreach ($pricing_class as $class) {
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'pricing'
            ), 'pricing');
}
Pf::shortcode()->add('head', array(
    $pf_aphrodite_shortcode,
    'pricing_head'
        ), 'pricing');
Pf::shortcode()->add('content', array(
    $pf_aphrodite_shortcode,
    'pricing_content'
        ), 'pricing');
Pf::shortcode()->add('footer', array(
    $pf_aphrodite_shortcode,
    'pricing_footer'
        ), 'pricing');

$thumb_class= array('normal','zoom');
foreach($thumb_class as $class){
    Pf::shortcode()->add($class, array(
        $pf_aphrodite_shortcode,
        'thumbnail'
            ), 'thumb');
}
Pf::shortcode()->add('tweets', array(
    $pf_aphrodite_shortcode,
    'tweets'
        ), 'social');
$alert_tags = array('alert-success','alert-info','alert-warning','alert-danger');
foreach ($alert_tags as $tag){
    Pf::shortcode ()->add ( $tag, array (
        $pf_aphrodite_shortcode,
        'alert'
    ),'bt');
    Pf::shortcode ()->add ( $tag, array (
        $pf_aphrodite_shortcode,
        'alert'
    ),'html');
}

$breadcrumb_types = array('page','post','post-category','gallery','portfolio','portfolio-category');
foreach ($breadcrumb_types as $tag){
    Pf::shortcode ()->add ( $tag, array (
        $pf_aphrodite_shortcode,
        'breadcrumb'
    ),'breadcrumb');
}

Pf::shortcode ()->add ( 'comment', array (
    $pf_aphrodite_shortcode,
    'comment'
),'html');
Pf::shortcode ()->add ( 'comment', array (
    $pf_aphrodite_shortcode,
    'comment'
),'php');

Pf::shortcode ()->add ( 'hr', array (
    $pf_aphrodite_shortcode,
    'hr'
),'html');

Pf::shortcode ()->add ( 'datetime', array (
    $pf_aphrodite_shortcode,
    'datetime'
),'php');
Pf::shortcode ()->add ( 'title', array (
    $pf_aphrodite_shortcode,
    'title_headline'
),'html');
Pf::shortcode ()->add ('url', array (
    $pf_aphrodite_shortcode,
    'get_url'
),'php');
Pf::shortcode ()->add ('script', array (
    $pf_aphrodite_shortcode,
    'script'
),'html');